/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.schema;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.api.WSXMLSchema;
import filenet.ws.listener.utils.Constants;
import filenet.ws.utils.WSSchemaValidator;
import filenet.ws.utils.WSSchemaValidatorResult;
import filenet.ws.utils.schema.ISchemaLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.axis.utils.XMLUtils;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSParser;

public class WSSchemaUtilsEx
implements DOMErrorHandler {
    private static String m_className = "filenet.ws.utils.schema".intern();
    protected static Logger logger = Logger.getLogger(m_className);
    private String[] m_sSchemas = null;
    private String[] m_sSchemasTNS = null;
    private boolean m_bExpandSchemas = false;
    private ISchemaLoader m_schemaLoader = null;
    private boolean fromServer = true;
    private URL m_localReferenceURL = null;
    private Boolean fromWSDL = null;
    private Vector importedFiles = new Vector();
    private Vector includedFiles = new Vector();
    private String m_sContextURI = null;
    private Document m_doc = null;
    private Element m_element = null;
    private static boolean USE_XMLSCHEMAAPI = false;
    private static final String XSDPATH = "P8BPMWSBroker" + Constants._XSD_;
    private XSModel m_xsModel = null;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    static LSParser builder;

    public void setFromServer(boolean b) {
        this.fromServer = b;
    }

    public boolean getFromServer() {
        return this.fromServer;
    }

    public String[] getSchemasTNS() throws VWException {
        if (this.m_sSchemasTNS == null) {
            this.retrieveSchemas();
        }
        return this.m_sSchemasTNS;
    }

    public String[] getSchemas() throws VWException {
        if (this.m_sSchemas == null) {
            this.retrieveSchemas();
        }
        return this.m_sSchemas;
    }

    public WSSchemaUtilsEx(String sContextURL, ISchemaLoader schemaLoader, boolean expandImport) throws VWException {
        this.m_bExpandSchemas = expandImport;
        this.m_schemaLoader = schemaLoader;
        try {
            this.m_sContextURI = new URL(sContextURL).toString();
        }
        catch (MalformedURLException mex) {
            File f = new File(sContextURL);
            if (f.exists()) {
                try {
                    this.m_sContextURI = f.toURL().toString();
                }
                catch (Exception e) {
                    throw new VWException(e);
                }
            }
            throw new VWException("filenet.ws.utils.schema.WSSchemaUtils.invalidURL", "{0} is not valid!!!", sContextURL);
        }
        try {
            this.m_doc = XMLUtils.newDocument((String)this.m_sContextURI);
            this.m_element = this.m_doc.getDocumentElement();
            this.retrieveSchemas();
        }
        catch (Exception e) {
            throw new VWException(e);
        }
    }

    public WSSchemaUtilsEx(String schemaText, String sContextURL, ISchemaLoader schemaLoader, boolean expandImport) throws VWException {
        this.m_bExpandSchemas = expandImport;
        this.m_schemaLoader = schemaLoader;
        this.m_sContextURI = sContextURL;
        try {
            this.m_doc = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(schemaText.getBytes("UTF-8")));
            this.m_element = this.m_doc.getDocumentElement();
            this.retrieveSchemas();
        }
        catch (Exception e) {
            throw new VWException(e);
        }
    }

    public WSSchemaUtilsEx(Document rootDoc, String sContextURL, boolean expandImport) throws VWException {
        this.m_doc = rootDoc;
        if (rootDoc == null) {
            throw new VWException("filenet.ws.utils.schema.WSSchemUtilsEx.fromDoc", "Invalid parameter for initialization.");
        }
        this.m_element = this.m_doc.getDocumentElement();
        this.m_sContextURI = sContextURL;
        this.m_bExpandSchemas = expandImport;
    }

    public WSSchemaValidatorResult validate() throws VWException {
        if (this.m_sSchemas == null) {
            this.retrieveSchemas();
        }
        return WSSchemaValidator.validate(this.m_sSchemasTNS, this.m_sContextURI == null ? "INST 0" : this.m_sContextURI, this.m_sSchemas, null);
    }

    public String[] getSchemaElementsEx() throws Exception {
        XSNamedMap map;
        if (!USE_XMLSCHEMAAPI) {
            throw new VWException("filenet.ws.utils.schema.WSSchemaUtilsEx.getSchemaElementsEx.NoXMLSchemaAPIYet", "Use of XML Schema API is not supported.");
        }
        this.initXSModel();
        if (this.m_xsModel != null && (map = this.m_xsModel.getComponents((short)2)).getLength() != 0) {
            String[] res = new String[map.getLength()];
            for (int i = 0; i < map.getLength(); ++i) {
                XSObject item = map.item(i);
                res[i] = item.getName();
            }
            return res;
        }
        return null;
    }

    public String[] getSchemaElements() throws Exception {
        return WSXMLSchema.getSchemaElements(this.getMainSchema());
    }

    public String getXMLTemplate(String schemaName, String element) throws Exception {
        return WSXMLSchema.getXMLTemplate(schemaName, this.getMainSchema(), element);
    }

    public String getExpressionTemplate(String schemaName, String schema, String element) throws Exception {
        return WSXMLSchema.getExpressionTemplate(schemaName, this.getMainSchema(), element);
    }

    public String getMainSchema() throws VWException {
        if (this.m_sSchemas == null) {
            this.retrieveSchemas();
        }
        if (this.m_sSchemas == null || this.m_sSchemas.length == 0) {
            return "";
        }
        return this.m_sSchemas[this.m_sSchemas.length - 1];
    }

    private URL getURL(String sContextURL, String spec) throws VWException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(spec);
            return url;
        }
        catch (Exception e) {
            try {
                try {
                    URL contextURL = null;
                    if (sContextURL != null) {
                        contextURL = new URL(sContextURL);
                    }
                    url = new URL(contextURL, path);
                    if (this.m_schemaLoader != null && url != null) {
                        path = this.m_schemaLoader.NormalizePath(url.toString(), path);
                    }
                    if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                        url = this.getFileURL(contextURL, path);
                    }
                }
                catch (Exception e2) {
                    url = null;
                }
                if (url == null) {
                    if (this.m_schemaLoader != null) {
                        url = this.m_schemaLoader.GetSchema(sContextURL, path);
                    } else {
                        throw new VWException("filenet.ws.utils.schema.WSSchemaUtils.NoSchemaLoader", "No schema loader available to load {0}, {1}.", sContextURL, path);
                    }
                }
                return url;
            }
            catch (VWException vwe) {
                throw vwe;
            }
            catch (Exception e3) {
                throw new VWException(e3);
            }
        }
    }

    private URL getFileURL(URL contextURL, String path) throws IOException, FileNotFoundException {
        File childFile = null;
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            childFile = new File(new File(contextFileName).getParentFile(), path);
        } else {
            childFile = new File(path);
        }
        if (!childFile.exists()) {
            throw new FileNotFoundException(childFile.getCanonicalPath());
        }
        return childFile.toURL();
    }

    private boolean elementIsWSDL(Element element) {
        if (element != null) {
            String localName = this.m_element.getLocalName();
            String namespace = this.m_element.getNamespaceURI();
            return localName != null && localName.equals("definitions") && namespace != null && namespace.equals(Constants.NS_WSDL);
        }
        return false;
    }

    private void retrieveSchemas() throws VWException {
        if (this.m_sSchemas != null) {
            return;
        }
        Vector schemas = new Vector();
        Vector schemasTNS = new Vector();
        try {
            if (!this.elementIsWSDL(this.m_element)) {
                this.handleImport(this.m_sContextURI, this.m_element, schemas, schemasTNS);
            } else {
                this.handleWSDLImport(this.m_sContextURI, this.m_doc, schemas, schemasTNS);
            }
            this.m_sSchemas = schemas.toArray(new String[0]);
            this.m_sSchemasTNS = schemasTNS.toArray(new String[0]);
            if (USE_XMLSCHEMAAPI) {
                this.m_localReferenceURL = this.m_schemaLoader.StoreSchema(this.getMainSchema());
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "retrieveSchemas", e);
            throw new VWException(e);
        }
    }

    private void addParentAttributes(Element element) {
        Node aNode = null;
        Element theElement = element;
        Element parentElement = null;
        do {
            if ((parentElement = (aNode = element.getParentNode()) != null && aNode instanceof Element ? (Element)aNode : null) == null) continue;
            NamedNodeMap parentAttributes = parentElement.getAttributes();
            for (int j = 0; j < parentAttributes.getLength(); ++j) {
                Attr attr = (Attr)parentAttributes.item(j);
                String attribName = attr.getName();
                if (theElement.hasAttribute(attribName) || attribName.compareTo("targetNamespace") != 0 && attribName.compareTo("namespace") != 0 && !attribName.startsWith("xmlns:")) continue;
                theElement.setAttribute(attr.getName(), attr.getValue());
            }
            element = parentElement;
        } while (parentElement != null);
    }

    private void handleImport(String context, Element rootElement, Vector schemas, Vector schemasTNS) throws Exception {
        String m_method = "handleImport";
        if (rootElement != null) {
            this.handleIncludes(context, rootElement);
            Node node = null;
            NodeList imports = rootElement.getElementsByTagNameNS("*", "import");
            for (int i = 0; i < imports.getLength(); ++i) {
                NamedNodeMap attributes;
                Node namespace;
                node = imports.item(i);
                if (node == null || (namespace = (attributes = node.getAttributes()).getNamedItem("namespace")) != null && WSSchemaUtilsEx.isKnownNamespace(namespace.getNodeName())) continue;
                String locationAttribute = "schemaLocation";
                Node importFile = attributes.getNamedItem(locationAttribute);
                if (importFile == null) {
                    locationAttribute = "location";
                    importFile = attributes.getNamedItem("location");
                }
                String importFileName = null;
                if (importFile != null) {
                    importFileName = importFile.getNodeValue();
                }
                if (this.m_bExpandSchemas) {
                    try {
                        attributes.removeNamedItem(locationAttribute);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (importFileName == null) continue;
                URL url = this.getURL(context, importFileName);
                String filename = url.toString();
                importFile.setNodeValue(filename);
                if (filename.indexOf(XSDPATH) > 0 || this.importedFiles.contains(url)) continue;
                this.importedFiles.add(url);
                Document importedDoc = XMLUtils.newDocument((String)filename);
                this.handleImport(filename, importedDoc.getDocumentElement(), schemas, schemasTNS);
            }
            this.addParentAttributes(rootElement);
            String targetNamespace = rootElement.getAttribute("targetNamespace");
            String s = WSTemplateBase.elementToString(rootElement);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, targetNamespace + " " + s);
            }
            schemasTNS.add(targetNamespace);
            schemas.add(s);
        }
    }

    private void handleRedefines(String context, Element rootElement) {
        String m_method = "handleRedefines";
        if (rootElement != null) {
            Node node = null;
            NodeList redefines = rootElement.getElementsByTagNameNS("*", "redefine");
            int nRedefines = redefines.getLength();
            for (int i = 0; i < nRedefines; ++i) {
                NamedNodeMap attributes;
                Node redefineFile;
                node = redefines.item(i);
                if (node == null || (redefineFile = (attributes = node.getAttributes()).getNamedItem("schemaLocation")) == null) continue;
                Node parentNode = node.getParentNode();
                try {
                    String location = redefineFile.getNodeValue();
                    URL url = this.getURL(context, redefineFile.getNodeValue());
                    redefineFile.setNodeValue(url.toString());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void handleIncludes(String context, Element rootElement) throws VWException {
        String m_method = "handleIncludes";
        if (rootElement != null) {
            this.handleRedefines(context, rootElement);
            Node node = null;
            NodeList includes = rootElement.getElementsByTagNameNS("*", "include");
            while (includes.getLength() > 0) {
                node = includes.item(0);
                if (node == null) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node namespace = attributes.getNamedItem("targetNamespace");
                Node includeFile = attributes.getNamedItem("schemaLocation");
                if (includeFile == null) {
                    includeFile = attributes.getNamedItem("location");
                }
                if (includeFile == null) continue;
                Node parentNode = node.getParentNode();
                try {
                    URL url = this.getURL(context, includeFile.getNodeValue());
                    includeFile.setNodeValue(url.toString());
                    String filename = url.toString();
                    Document includedDoc = XMLUtils.newDocument((String)filename);
                    this.handleIncludes(filename, includedDoc.getDocumentElement());
                    NamedNodeMap parentAttribs = parentNode.getAttributes();
                    NodeList schemaList = includedDoc.getElementsByTagNameNS("*", "schema");
                    for (int j = 0; j < schemaList.getLength(); ++j) {
                        Node schema = schemaList.item(j);
                        NamedNodeMap attribs = schema.getAttributes();
                        for (int k = 0; k < attribs.getLength(); ++k) {
                            Node attrib = attribs.item(k);
                            if (parentAttribs.getNamedItem(attrib.getNodeName()) != null) continue;
                            Attr newAttrib = rootElement.getOwnerDocument().createAttribute(attrib.getNodeName());
                            newAttrib.setNodeValue(attrib.getNodeValue());
                            parentAttribs.setNamedItem(newAttrib);
                        }
                        NodeList children = schema.getChildNodes();
                        for (int k = 0; k < children.getLength(); ++k) {
                            Node child = children.item(k);
                            if (child == null || !(child instanceof Element)) continue;
                            Node aNode = rootElement.getOwnerDocument().importNode(child, true);
                            parentNode.insertBefore(aNode, node);
                        }
                    }
                    parentNode.removeChild(node);
                }
                catch (Exception ex) {
                    logger.throwing(m_className, m_method, ex);
                    throw new VWException(ex);
                }
            }
        }
    }

    protected void handleWSDLImport(String context, Document rootElement, Vector schemas, Vector schemasTNS) throws Exception {
        String m_method = "handleWSDLImports";
        if (rootElement != null) {
            this.handleWSDLIncludes(context, rootElement);
            Node node = null;
            NodeList imports = rootElement.getElementsByTagNameNS(Constants.NS_WSDL, "import");
            for (int i = 0; i < imports.getLength(); ++i) {
                String locationAttribute;
                node = imports.item(i);
                if (node == null) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node importFile = attributes.getNamedItem(locationAttribute = "schemaLocation");
                if (importFile == null) {
                    locationAttribute = "location";
                    importFile = attributes.getNamedItem("location");
                }
                String importFileName = null;
                if (importFile != null) {
                    importFileName = importFile.getNodeValue();
                }
                if (importFileName == null) continue;
                URL url = this.getURL(context, importFileName);
                String filename = url.toString();
                importFile.setNodeValue(filename);
                Document importedDoc = XMLUtils.newDocument((String)filename);
                this.handleWSDLImport(filename, importedDoc, schemas, schemasTNS);
            }
            NodeList schemaList = rootElement.getElementsByTagNameNS(Constants.NS_XMLSCHEMA, "schema");
            for (int j = 0; j < schemaList.getLength(); ++j) {
                node = schemaList.item(j);
                if (!(node instanceof Element)) continue;
                this.handleImport(context, (Element)node, schemas, schemasTNS);
            }
        }
    }

    protected void handleWSDLIncludes(String context, Document rootElement) throws Exception {
        String m_method = "handleWSDLIncludes";
        if (rootElement != null) {
            Node node = null;
            NodeList includes = rootElement.getElementsByTagNameNS(Constants.NS_WSDL20, "include");
            int nIncludes = includes.getLength();
            for (int i = 0; i < includes.getLength(); ++i) {
                node = includes.item(0);
                if (node == null) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node namespace = attributes.getNamedItem("targetNamespace");
                Node includeFile = attributes.getNamedItem("schemaLocation");
                if (includeFile == null) {
                    includeFile = attributes.getNamedItem("location");
                }
                if (includeFile == null) continue;
                Node parentNode = node.getParentNode();
                URL url = this.getURL(context, includeFile.getNodeValue());
                if (!this.includedFiles.contains(url)) {
                    String filename = url.toString();
                    this.includedFiles.add(url);
                    Document includedDoc = XMLUtils.newDocument((String)filename);
                    this.handleWSDLIncludes(filename, includedDoc);
                    NamedNodeMap parentAttribs = parentNode.getAttributes();
                    NodeList schemaList = includedDoc.getElementsByTagNameNS("*", "schema");
                    if (schemaList != null) {
                        for (int j = 0; j < schemaList.getLength(); ++j) {
                            Node schema = schemaList.item(j);
                            NamedNodeMap attribs = schema.getAttributes();
                            for (int k = 0; k < attribs.getLength(); ++k) {
                                Node attrib = attribs.item(k);
                                if (parentAttribs.getNamedItem(attrib.getNodeName()) != null) continue;
                                Attr newAttrib = rootElement.getOwnerDocument().createAttribute(attrib.getNodeName());
                                newAttrib.setNodeValue(attrib.getNodeValue());
                                parentAttribs.setNamedItem(newAttrib);
                            }
                            NodeList children = schema.getChildNodes();
                            for (int k = 0; k < children.getLength(); ++k) {
                                Node child = children.item(k);
                                if (child == null || !(child instanceof Element)) continue;
                                Node aNode = rootElement.getOwnerDocument().importNode(child, true);
                                parentNode.insertBefore(aNode, node);
                            }
                        }
                    }
                }
                parentNode.removeChild(node);
            }
        }
    }

    public static boolean isKnownNamespace(String namespace) {
        if (org.apache.axis.Constants.isSOAP_ENC((String)namespace)) {
            return true;
        }
        if (org.apache.axis.Constants.isSchemaXSD((String)namespace)) {
            return true;
        }
        if (org.apache.axis.Constants.isSchemaXSI((String)namespace)) {
            return true;
        }
        return namespace.equals("http://www.w3.org/XML/1998/namespace");
    }

    private void initXSModel() throws Exception {
        if (this.m_xsModel != null) {
            return;
        }
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMConfiguration config = schemaLoader.getConfig();
        WSSchemaUtilsEx errorHandler = this;
        config.setParameter("error-handler", errorHandler);
        config.setParameter("validate", Boolean.TRUE);
        this.m_xsModel = schemaLoader.loadURI(this.m_localReferenceURL.toString());
    }

    public boolean handleError(DOMError error) {
        short severity = error.getSeverity();
        if (severity == 2) {
            System.out.println("[xs-error]: " + error.getMessage());
        }
        if (severity == 1) {
            System.out.println("[xs-warning]: " + error.getMessage());
        }
        return true;
    }

    private static void printUsage() {
        System.out.println("/nItems=## /item1=xx /item2=xx.../itemN=xxx");
        System.out.println("/noexpand /novalidate");
        System.out.println("Or put in /inputfile=propertiesFile");
    }

    public static void main(String[] args) {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        if (c.isPresent("H") || c.isPresent("?")) {
            WSSchemaUtilsEx.printUsage();
        }
        boolean expand = !c.isPresent("noexpand");
        boolean validate = !c.isPresent("novalidate");
        int nItems = c.getIntParameter("nItems", 1);
        for (int i = 1; i <= nItems; ++i) {
            String item = c.getParameter("item" + i);
            if (item == null) continue;
            System.out.println("--------- " + item + " -------------");
            try {
                WSSchemaUtilsEx ws = new WSSchemaUtilsEx(item, null, expand);
                String[] schemas = ws.getSchemas();
                int nSchemas = schemas == null ? 0 : schemas.length;
                System.out.println("Number of schemas found = " + nSchemas);
                for (int j = 0; j < nSchemas; ++j) {
                    System.out.println("Schema[" + j + "]");
                    System.out.println(schemas[j]);
                }
                String[] schemasTNS = ws.getSchemasTNS();
                int nSchemasTNS = schemasTNS == null ? 0 : schemasTNS.length;
                for (int j = 0; j < nSchemasTNS; ++j) {
                    System.out.println("targetnamespace[" + j + "]=" + schemasTNS[j]);
                }
                if (!validate) continue;
                try {
                    System.out.println("****** Validating....");
                    WSSchemaValidatorResult res = WSSchemaValidator.validate(schemasTNS, item, schemas, null);
                    if (!res.getValid()) {
                        VWException vwe = new VWException("ws.WSOperations.FailedValidateInputMsg", "Exception: {0}", res.toString());
                        throw vwe;
                    }
                    System.out.println("LOOKING GOOD!!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

